-- 烧毁的板叶盆预制件
local assets = {
    Asset("ANIM", "anim/potted_boardleaf.zip"), -- 使用相同的动画文件
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.entity:AddSoundEmitter()

    -- 设置碰撞
    MakeObstaclePhysics(inst, 0.5)

    -- 动画设置
    inst.AnimState:SetBank("entity")
    inst.AnimState:SetBuild("potted_boardleaf")
    inst.AnimState:PlayAnimation("potted_boardleaf_burnt", true) -- 播放烧毁状态的动画
    inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetFinalOffset(1)

    -- 可检查组件
    inst:AddComponent("inspectable")
    inst.components.inspectable.nameoverride = "POTTED_BOARDLEAF_BURNT"

    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end

    -- 服务器端代码
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetLoot({"ash"}) -- 烧毁后掉落灰烬

-- 可摧毁组件（可以被锤子拆除）
inst:AddComponent("workable")
inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
inst.components.workable:SetWorkLeft(1) -- 只需要敲击1下
inst.components.workable:SetOnWorkCallback(function(inst, worker, workleft)
    if workleft <= 0 then
        local collapse = SpawnPrefab("collapse_small")
        if collapse then
            collapse.Transform:SetPosition(inst.Transform:GetWorldPosition())
        end
        inst.components.lootdropper:DropLoot()
        inst:Remove()
    end
end)

    -- 标记
    inst:AddTag("structure")
    inst:AddTag("burnt")

    return inst
end

return Prefab("potted_boardleaf_burnt", fn, assets)